/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ChannelNamespace;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesRequest;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesResponse;

public class ListChannelNamespacesPublisher
implements SdkPublisher<ListChannelNamespacesResponse> {
    private final AppSyncAsyncClient client;
    private final ListChannelNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelNamespacesPublisher(AppSyncAsyncClient client, ListChannelNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelNamespacesPublisher(AppSyncAsyncClient client, ListChannelNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChannelNamespace> channelNamespaces() {
        Function<ListChannelNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelNamespaces() != null) {
                return response.channelNamespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChannelNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChannelNamespacesResponseFetcher
    implements AsyncPageFetcher<ListChannelNamespacesResponse> {
        private ListChannelNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelNamespacesResponse> nextPage(ListChannelNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelNamespacesPublisher.this.client.listChannelNamespaces(ListChannelNamespacesPublisher.this.firstRequest);
            }
            return ListChannelNamespacesPublisher.this.client.listChannelNamespaces((ListChannelNamespacesRequest)((Object)ListChannelNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

