/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.RdsHttpEndpointConfig;
import software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseDataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseDataSourceConfig> {
    private static final SdkField<String> RELATIONAL_DATABASE_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseSourceType").getter(RelationalDatabaseDataSourceConfig.getter(RelationalDatabaseDataSourceConfig::relationalDatabaseSourceTypeAsString)).setter(RelationalDatabaseDataSourceConfig.setter(Builder::relationalDatabaseSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSourceType").build()}).build();
    private static final SdkField<RdsHttpEndpointConfig> RDS_HTTP_ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsHttpEndpointConfig").getter(RelationalDatabaseDataSourceConfig.getter(RelationalDatabaseDataSourceConfig::rdsHttpEndpointConfig)).setter(RelationalDatabaseDataSourceConfig.setter(Builder::rdsHttpEndpointConfig)).constructor(RdsHttpEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsHttpEndpointConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_SOURCE_TYPE_FIELD, RDS_HTTP_ENDPOINT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("relationalDatabaseSourceType", RELATIONAL_DATABASE_SOURCE_TYPE_FIELD);
            this.put("rdsHttpEndpointConfig", RDS_HTTP_ENDPOINT_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String relationalDatabaseSourceType;
    private final RdsHttpEndpointConfig rdsHttpEndpointConfig;

    private RelationalDatabaseDataSourceConfig(BuilderImpl builder) {
        this.relationalDatabaseSourceType = builder.relationalDatabaseSourceType;
        this.rdsHttpEndpointConfig = builder.rdsHttpEndpointConfig;
    }

    public final RelationalDatabaseSourceType relationalDatabaseSourceType() {
        return RelationalDatabaseSourceType.fromValue(this.relationalDatabaseSourceType);
    }

    public final String relationalDatabaseSourceTypeAsString() {
        return this.relationalDatabaseSourceType;
    }

    public final RdsHttpEndpointConfig rdsHttpEndpointConfig() {
        return this.rdsHttpEndpointConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsHttpEndpointConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseDataSourceConfig)) {
            return false;
        }
        RelationalDatabaseDataSourceConfig other = (RelationalDatabaseDataSourceConfig)obj;
        return Objects.equals(this.relationalDatabaseSourceTypeAsString(), other.relationalDatabaseSourceTypeAsString()) && Objects.equals(this.rdsHttpEndpointConfig(), other.rdsHttpEndpointConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseDataSourceConfig").add("RelationalDatabaseSourceType", (Object)this.relationalDatabaseSourceTypeAsString()).add("RdsHttpEndpointConfig", (Object)this.rdsHttpEndpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseSourceType": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseSourceTypeAsString()));
            }
            case "rdsHttpEndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.rdsHttpEndpointConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseDataSourceConfig, T> g) {
        return obj -> g.apply((RelationalDatabaseDataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relationalDatabaseSourceType;
        private RdsHttpEndpointConfig rdsHttpEndpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseDataSourceConfig model) {
            this.relationalDatabaseSourceType(model.relationalDatabaseSourceType);
            this.rdsHttpEndpointConfig(model.rdsHttpEndpointConfig);
        }

        public final String getRelationalDatabaseSourceType() {
            return this.relationalDatabaseSourceType;
        }

        public final void setRelationalDatabaseSourceType(String relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType = relationalDatabaseSourceType;
        }

        @Override
        public final Builder relationalDatabaseSourceType(String relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType = relationalDatabaseSourceType;
            return this;
        }

        @Override
        public final Builder relationalDatabaseSourceType(RelationalDatabaseSourceType relationalDatabaseSourceType) {
            this.relationalDatabaseSourceType(relationalDatabaseSourceType == null ? null : relationalDatabaseSourceType.toString());
            return this;
        }

        public final RdsHttpEndpointConfig.Builder getRdsHttpEndpointConfig() {
            return this.rdsHttpEndpointConfig != null ? this.rdsHttpEndpointConfig.toBuilder() : null;
        }

        public final void setRdsHttpEndpointConfig(RdsHttpEndpointConfig.BuilderImpl rdsHttpEndpointConfig) {
            this.rdsHttpEndpointConfig = rdsHttpEndpointConfig != null ? rdsHttpEndpointConfig.build() : null;
        }

        @Override
        public final Builder rdsHttpEndpointConfig(RdsHttpEndpointConfig rdsHttpEndpointConfig) {
            this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
            return this;
        }

        public RelationalDatabaseDataSourceConfig build() {
            return new RelationalDatabaseDataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseDataSourceConfig> {
        public Builder relationalDatabaseSourceType(String var1);

        public Builder relationalDatabaseSourceType(RelationalDatabaseSourceType var1);

        public Builder rdsHttpEndpointConfig(RdsHttpEndpointConfig var1);

        default public Builder rdsHttpEndpointConfig(Consumer<RdsHttpEndpointConfig.Builder> rdsHttpEndpointConfig) {
            return this.rdsHttpEndpointConfig((RdsHttpEndpointConfig)((RdsHttpEndpointConfig.Builder)RdsHttpEndpointConfig.builder().applyMutation(rdsHttpEndpointConfig)).build());
        }
    }
}

