/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GraphQLApiType {
    GRAPHQL("GRAPHQL"),
    MERGED("MERGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GraphQLApiType> VALUE_MAP;
    private final String value;

    private GraphQLApiType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GraphQLApiType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GraphQLApiType> knownValues() {
        EnumSet<GraphQLApiType> knownValues = EnumSet.allOf(GraphQLApiType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GraphQLApiType.class, GraphQLApiType::toString);
    }
}

