/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClientBuilder;
import software.amazon.awssdk.services.appsync.AppSyncServiceClientConfiguration;
import software.amazon.awssdk.services.appsync.DefaultAppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.DefaultAppSyncBaseClientBuilder;
import software.amazon.awssdk.services.appsync.endpoints.AppSyncEndpointProvider;

@SdkInternalApi
final class DefaultAppSyncAsyncClientBuilder
extends DefaultAppSyncBaseClientBuilder<AppSyncAsyncClientBuilder, AppSyncAsyncClient>
implements AppSyncAsyncClientBuilder {
    DefaultAppSyncAsyncClientBuilder() {
    }

    @Override
    public DefaultAppSyncAsyncClientBuilder endpointProvider(AppSyncEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppSyncAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppSyncAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AppSyncServiceClientConfiguration serviceClientConfiguration = AppSyncServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAppSyncAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

