/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuntimeName {
    APPSYNC_JS("APPSYNC_JS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuntimeName> VALUE_MAP;
    private final String value;

    private RuntimeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuntimeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuntimeName> knownValues() {
        EnumSet<RuntimeName> knownValues = EnumSet.allOf(RuntimeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuntimeName.class, RuntimeName::toString);
    }
}

