/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TypeDefinitionFormat {
    SDL("SDL"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TypeDefinitionFormat> VALUE_MAP;
    private final String value;

    private TypeDefinitionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeDefinitionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeDefinitionFormat> knownValues() {
        EnumSet<TypeDefinitionFormat> knownValues = EnumSet.allOf(TypeDefinitionFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TypeDefinitionFormat.class, TypeDefinitionFormat::toString);
    }
}

