/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaStatus {
    PROCESSING("PROCESSING"),
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    SUCCESS("SUCCESS"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaStatus> VALUE_MAP;
    private final String value;

    private SchemaStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaStatus> knownValues() {
        EnumSet<SchemaStatus> knownValues = EnumSet.allOf(SchemaStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaStatus.class, SchemaStatus::toString);
    }
}

