/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainNameConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainNameConfig> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DomainNameConfig.getter(DomainNameConfig::domainName)).setter(DomainNameConfig.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DomainNameConfig.getter(DomainNameConfig::description)).setter(DomainNameConfig.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(DomainNameConfig.getter(DomainNameConfig::certificateArn)).setter(DomainNameConfig.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> APPSYNC_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appsyncDomainName").getter(DomainNameConfig.getter(DomainNameConfig::appsyncDomainName)).setter(DomainNameConfig.setter(Builder::appsyncDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appsyncDomainName").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostedZoneId").getter(DomainNameConfig.getter(DomainNameConfig::hostedZoneId)).setter(DomainNameConfig.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DESCRIPTION_FIELD, CERTIFICATE_ARN_FIELD, APPSYNC_DOMAIN_NAME_FIELD, HOSTED_ZONE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String description;
    private final String certificateArn;
    private final String appsyncDomainName;
    private final String hostedZoneId;

    private DomainNameConfig(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.description = builder.description;
        this.certificateArn = builder.certificateArn;
        this.appsyncDomainName = builder.appsyncDomainName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String description() {
        return this.description;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String appsyncDomainName() {
        return this.appsyncDomainName;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appsyncDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNameConfig)) {
            return false;
        }
        DomainNameConfig other = (DomainNameConfig)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.appsyncDomainName(), other.appsyncDomainName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"DomainNameConfig").add("DomainName", (Object)this.domainName()).add("Description", (Object)this.description()).add("CertificateArn", (Object)this.certificateArn()).add("AppsyncDomainName", (Object)this.appsyncDomainName()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "appsyncDomainName": {
                return Optional.ofNullable(clazz.cast(this.appsyncDomainName()));
            }
            case "hostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainNameConfig, T> g) {
        return obj -> g.apply((DomainNameConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String description;
        private String certificateArn;
        private String appsyncDomainName;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNameConfig model) {
            this.domainName(model.domainName);
            this.description(model.description);
            this.certificateArn(model.certificateArn);
            this.appsyncDomainName(model.appsyncDomainName);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAppsyncDomainName() {
            return this.appsyncDomainName;
        }

        public final void setAppsyncDomainName(String appsyncDomainName) {
            this.appsyncDomainName = appsyncDomainName;
        }

        @Override
        @Transient
        public final Builder appsyncDomainName(String appsyncDomainName) {
            this.appsyncDomainName = appsyncDomainName;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        @Transient
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public DomainNameConfig build() {
            return new DomainNameConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainNameConfig> {
        public Builder domainName(String var1);

        public Builder description(String var1);

        public Builder certificateArn(String var1);

        public Builder appsyncDomainName(String var1);

        public Builder hostedZoneId(String var1);
    }
}

