/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.DataSourceType;
import software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.HttpDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSourceRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::apiId)).setter(UpdateDataSourceRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::name)).setter(UpdateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::description)).setter(UpdateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::typeAsString)).setter(UpdateDataSourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRoleArn").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::serviceRoleArn)).setter(UpdateDataSourceRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()}).build();
    private static final SdkField<DynamodbDataSourceConfig> DYNAMODB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamodbConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::dynamodbConfig)).setter(UpdateDataSourceRequest.setter(Builder::dynamodbConfig)).constructor(DynamodbDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbConfig").build()}).build();
    private static final SdkField<LambdaDataSourceConfig> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::lambdaConfig)).setter(UpdateDataSourceRequest.setter(Builder::lambdaConfig)).constructor(LambdaDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()}).build();
    private static final SdkField<ElasticsearchDataSourceConfig> ELASTICSEARCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elasticsearchConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::elasticsearchConfig)).setter(UpdateDataSourceRequest.setter(Builder::elasticsearchConfig)).constructor(ElasticsearchDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearchConfig").build()}).build();
    private static final SdkField<OpenSearchServiceDataSourceConfig> OPEN_SEARCH_SERVICE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openSearchServiceConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::openSearchServiceConfig)).setter(UpdateDataSourceRequest.setter(Builder::openSearchServiceConfig)).constructor(OpenSearchServiceDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchServiceConfig").build()}).build();
    private static final SdkField<HttpDataSourceConfig> HTTP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::httpConfig)).setter(UpdateDataSourceRequest.setter(Builder::httpConfig)).constructor(HttpDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpConfig").build()}).build();
    private static final SdkField<RelationalDatabaseDataSourceConfig> RELATIONAL_DATABASE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relationalDatabaseConfig").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::relationalDatabaseConfig)).setter(UpdateDataSourceRequest.setter(Builder::relationalDatabaseConfig)).constructor(RelationalDatabaseDataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, SERVICE_ROLE_ARN_FIELD, DYNAMODB_CONFIG_FIELD, LAMBDA_CONFIG_FIELD, ELASTICSEARCH_CONFIG_FIELD, OPEN_SEARCH_SERVICE_CONFIG_FIELD, HTTP_CONFIG_FIELD, RELATIONAL_DATABASE_CONFIG_FIELD));
    private final String apiId;
    private final String name;
    private final String description;
    private final String type;
    private final String serviceRoleArn;
    private final DynamodbDataSourceConfig dynamodbConfig;
    private final LambdaDataSourceConfig lambdaConfig;
    private final ElasticsearchDataSourceConfig elasticsearchConfig;
    private final OpenSearchServiceDataSourceConfig openSearchServiceConfig;
    private final HttpDataSourceConfig httpConfig;
    private final RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.dynamodbConfig = builder.dynamodbConfig;
        this.lambdaConfig = builder.lambdaConfig;
        this.elasticsearchConfig = builder.elasticsearchConfig;
        this.openSearchServiceConfig = builder.openSearchServiceConfig;
        this.httpConfig = builder.httpConfig;
        this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final DynamodbDataSourceConfig dynamodbConfig() {
        return this.dynamodbConfig;
    }

    public final LambdaDataSourceConfig lambdaConfig() {
        return this.lambdaConfig;
    }

    public final ElasticsearchDataSourceConfig elasticsearchConfig() {
        return this.elasticsearchConfig;
    }

    public final OpenSearchServiceDataSourceConfig openSearchServiceConfig() {
        return this.openSearchServiceConfig;
    }

    public final HttpDataSourceConfig httpConfig() {
        return this.httpConfig;
    }

    public final RelationalDatabaseDataSourceConfig relationalDatabaseConfig() {
        return this.relationalDatabaseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.openSearchServiceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.dynamodbConfig(), other.dynamodbConfig()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.elasticsearchConfig(), other.elasticsearchConfig()) && Objects.equals(this.openSearchServiceConfig(), other.openSearchServiceConfig()) && Objects.equals(this.httpConfig(), other.httpConfig()) && Objects.equals(this.relationalDatabaseConfig(), other.relationalDatabaseConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataSourceRequest").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("DynamodbConfig", (Object)this.dynamodbConfig()).add("LambdaConfig", (Object)this.lambdaConfig()).add("ElasticsearchConfig", (Object)this.elasticsearchConfig()).add("OpenSearchServiceConfig", (Object)this.openSearchServiceConfig()).add("HttpConfig", (Object)this.httpConfig()).add("RelationalDatabaseConfig", (Object)this.relationalDatabaseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "serviceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "dynamodbConfig": {
                return Optional.ofNullable(clazz.cast(this.dynamodbConfig()));
            }
            case "lambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "elasticsearchConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchConfig()));
            }
            case "openSearchServiceConfig": {
                return Optional.ofNullable(clazz.cast(this.openSearchServiceConfig()));
            }
            case "httpConfig": {
                return Optional.ofNullable(clazz.cast(this.httpConfig()));
            }
            case "relationalDatabaseConfig": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private String description;
        private String type;
        private String serviceRoleArn;
        private DynamodbDataSourceConfig dynamodbConfig;
        private LambdaDataSourceConfig lambdaConfig;
        private ElasticsearchDataSourceConfig elasticsearchConfig;
        private OpenSearchServiceDataSourceConfig openSearchServiceConfig;
        private HttpDataSourceConfig httpConfig;
        private RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.serviceRoleArn(model.serviceRoleArn);
            this.dynamodbConfig(model.dynamodbConfig);
            this.lambdaConfig(model.lambdaConfig);
            this.elasticsearchConfig(model.elasticsearchConfig);
            this.openSearchServiceConfig(model.openSearchServiceConfig);
            this.httpConfig(model.httpConfig);
            this.relationalDatabaseConfig(model.relationalDatabaseConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final DynamodbDataSourceConfig.Builder getDynamodbConfig() {
            return this.dynamodbConfig != null ? this.dynamodbConfig.toBuilder() : null;
        }

        public final void setDynamodbConfig(DynamodbDataSourceConfig.BuilderImpl dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig != null ? dynamodbConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig;
            return this;
        }

        public final LambdaDataSourceConfig.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaDataSourceConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final ElasticsearchDataSourceConfig.Builder getElasticsearchConfig() {
            return this.elasticsearchConfig != null ? this.elasticsearchConfig.toBuilder() : null;
        }

        public final void setElasticsearchConfig(ElasticsearchDataSourceConfig.BuilderImpl elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig != null ? elasticsearchConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        public final OpenSearchServiceDataSourceConfig.Builder getOpenSearchServiceConfig() {
            return this.openSearchServiceConfig != null ? this.openSearchServiceConfig.toBuilder() : null;
        }

        public final void setOpenSearchServiceConfig(OpenSearchServiceDataSourceConfig.BuilderImpl openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig != null ? openSearchServiceConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder openSearchServiceConfig(OpenSearchServiceDataSourceConfig openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        public final HttpDataSourceConfig.Builder getHttpConfig() {
            return this.httpConfig != null ? this.httpConfig.toBuilder() : null;
        }

        public final void setHttpConfig(HttpDataSourceConfig.BuilderImpl httpConfig) {
            this.httpConfig = httpConfig != null ? httpConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder httpConfig(HttpDataSourceConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public final RelationalDatabaseDataSourceConfig.Builder getRelationalDatabaseConfig() {
            return this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.toBuilder() : null;
        }

        public final void setRelationalDatabaseConfig(RelationalDatabaseDataSourceConfig.BuilderImpl relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig != null ? relationalDatabaseConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSourceRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder serviceRoleArn(String var1);

        public Builder dynamodbConfig(DynamodbDataSourceConfig var1);

        default public Builder dynamodbConfig(Consumer<DynamodbDataSourceConfig.Builder> dynamodbConfig) {
            return this.dynamodbConfig((DynamodbDataSourceConfig)((DynamodbDataSourceConfig.Builder)DynamodbDataSourceConfig.builder().applyMutation(dynamodbConfig)).build());
        }

        public Builder lambdaConfig(LambdaDataSourceConfig var1);

        default public Builder lambdaConfig(Consumer<LambdaDataSourceConfig.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaDataSourceConfig)((LambdaDataSourceConfig.Builder)LambdaDataSourceConfig.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder elasticsearchConfig(ElasticsearchDataSourceConfig var1);

        default public Builder elasticsearchConfig(Consumer<ElasticsearchDataSourceConfig.Builder> elasticsearchConfig) {
            return this.elasticsearchConfig((ElasticsearchDataSourceConfig)((ElasticsearchDataSourceConfig.Builder)ElasticsearchDataSourceConfig.builder().applyMutation(elasticsearchConfig)).build());
        }

        public Builder openSearchServiceConfig(OpenSearchServiceDataSourceConfig var1);

        default public Builder openSearchServiceConfig(Consumer<OpenSearchServiceDataSourceConfig.Builder> openSearchServiceConfig) {
            return this.openSearchServiceConfig((OpenSearchServiceDataSourceConfig)((OpenSearchServiceDataSourceConfig.Builder)OpenSearchServiceDataSourceConfig.builder().applyMutation(openSearchServiceConfig)).build());
        }

        public Builder httpConfig(HttpDataSourceConfig var1);

        default public Builder httpConfig(Consumer<HttpDataSourceConfig.Builder> httpConfig) {
            return this.httpConfig((HttpDataSourceConfig)((HttpDataSourceConfig.Builder)HttpDataSourceConfig.builder().applyMutation(httpConfig)).build());
        }

        public Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig var1);

        default public Builder relationalDatabaseConfig(Consumer<RelationalDatabaseDataSourceConfig.Builder> relationalDatabaseConfig) {
            return this.relationalDatabaseConfig((RelationalDatabaseDataSourceConfig)((RelationalDatabaseDataSourceConfig.Builder)RelationalDatabaseDataSourceConfig.builder().applyMutation(relationalDatabaseConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

