/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSchemaCreationRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, StartSchemaCreationRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(StartSchemaCreationRequest.getter(StartSchemaCreationRequest::apiId)).setter(StartSchemaCreationRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<SdkBytes> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("definition").getter(StartSchemaCreationRequest.getter(StartSchemaCreationRequest::definition)).setter(StartSchemaCreationRequest.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, DEFINITION_FIELD));
    private final String apiId;
    private final SdkBytes definition;

    private StartSchemaCreationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.definition = builder.definition;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final SdkBytes definition() {
        return this.definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaCreationRequest)) {
            return false;
        }
        StartSchemaCreationRequest other = (StartSchemaCreationRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"StartSchemaCreationRequest").add("ApiId", (Object)this.apiId()).add("Definition", (Object)this.definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSchemaCreationRequest, T> g) {
        return obj -> g.apply((StartSchemaCreationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private SdkBytes definition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaCreationRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.definition(model.definition);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final ByteBuffer getDefinition() {
            return this.definition == null ? null : this.definition.asByteBuffer();
        }

        @Override
        public final Builder definition(SdkBytes definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(ByteBuffer definition) {
            this.definition(definition == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)definition));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSchemaCreationRequest build() {
            return new StartSchemaCreationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSchemaCreationRequest> {
        public Builder apiId(String var1);

        public Builder definition(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

