/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AuthorizationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpDataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpDataSourceConfig> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(HttpDataSourceConfig.getter(HttpDataSourceConfig::endpoint)).setter(HttpDataSourceConfig.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<AuthorizationConfig> AUTHORIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizationConfig").getter(HttpDataSourceConfig.getter(HttpDataSourceConfig::authorizationConfig)).setter(HttpDataSourceConfig.setter(Builder::authorizationConfig)).constructor(AuthorizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, AUTHORIZATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final AuthorizationConfig authorizationConfig;

    private HttpDataSourceConfig(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.authorizationConfig = builder.authorizationConfig;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public AuthorizationConfig authorizationConfig() {
        return this.authorizationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpDataSourceConfig)) {
            return false;
        }
        HttpDataSourceConfig other = (HttpDataSourceConfig)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.authorizationConfig(), other.authorizationConfig());
    }

    public String toString() {
        return ToString.builder((String)"HttpDataSourceConfig").add("Endpoint", (Object)this.endpoint()).add("AuthorizationConfig", (Object)this.authorizationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "authorizationConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizationConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpDataSourceConfig, T> g) {
        return obj -> g.apply((HttpDataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private AuthorizationConfig authorizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpDataSourceConfig model) {
            this.endpoint(model.endpoint);
            this.authorizationConfig(model.authorizationConfig);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final AuthorizationConfig.Builder getAuthorizationConfig() {
            return this.authorizationConfig != null ? this.authorizationConfig.toBuilder() : null;
        }

        @Override
        public final Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        public final void setAuthorizationConfig(AuthorizationConfig.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        public HttpDataSourceConfig build() {
            return new HttpDataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpDataSourceConfig> {
        public Builder endpoint(String var1);

        public Builder authorizationConfig(AuthorizationConfig var1);

        default public Builder authorizationConfig(Consumer<AuthorizationConfig.Builder> authorizationConfig) {
            return this.authorizationConfig((AuthorizationConfig)((AuthorizationConfig.Builder)AuthorizationConfig.builder().applyMutation(authorizationConfig)).build());
        }
    }
}

