/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.model.AccessDeniedException;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.CreateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.FlushApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversByFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;

@SdkInternalApi
final class DefaultAppSyncClient
implements AppSyncClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "appsync";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiCacheResponse createApiCache(CreateApiCacheRequest createApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiCacheResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApiCache");
            CreateApiCacheResponse createApiCacheResponse = (CreateApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiCache").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApiCacheRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiCacheResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createApiCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApiKey");
            CreateApiKeyResponse createApiKeyResponse = (CreateApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApiKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createApiKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataSource");
            CreateDataSourceResponse createDataSourceResponse = (CreateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createDataSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFunctionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFunction");
            CreateFunctionResponse createFunctionResponse = (CreateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFunction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFunctionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFunctionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createFunctionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) throws BadRequestException, LimitExceededException, ConcurrentModificationException, UnauthorizedException, InternalFailureException, ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphqlApiResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraphqlApi");
            CreateGraphqlApiResponse createGraphqlApiResponse = (CreateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraphqlApi").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGraphqlApiRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphqlApiResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createGraphqlApiRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResolverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResolver");
            CreateResolverResponse createResolverResponse = (CreateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResolver").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResolverRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResolverResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createResolverRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateType");
            CreateTypeResponse createTypeResponse = (CreateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, createTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiCacheResponse deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiCacheResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApiCache");
            DeleteApiCacheResponse deleteApiCacheResponse = (DeleteApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiCache").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApiCacheRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiCacheResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteApiCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApiKey");
            DeleteApiKeyResponse deleteApiKeyResponse = (DeleteApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApiKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteApiKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataSource");
            DeleteDataSourceResponse deleteDataSourceResponse = (DeleteDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDataSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFunctionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFunction");
            DeleteFunctionResponse deleteFunctionResponse = (DeleteFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFunction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFunctionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFunctionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFunctionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphqlApiResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGraphqlApi");
            DeleteGraphqlApiResponse deleteGraphqlApiResponse = (DeleteGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraphqlApi").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGraphqlApiRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGraphqlApiResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteGraphqlApiRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResolverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResolver");
            DeleteResolverResponse deleteResolverResponse = (DeleteResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResolver").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResolverRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResolverResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteResolverRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteType");
            DeleteTypeResponse deleteTypeResponse = (DeleteTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlushApiCacheResponse flushApiCache(FlushApiCacheRequest flushApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FlushApiCacheResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FlushApiCache");
            FlushApiCacheResponse flushApiCacheResponse = (FlushApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FlushApiCache").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)flushApiCacheRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new FlushApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return flushApiCacheResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, flushApiCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApiCacheResponse getApiCache(GetApiCacheRequest getApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApiCacheResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApiCache");
            GetApiCacheResponse getApiCacheResponse = (GetApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApiCache").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getApiCacheRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApiCacheResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getApiCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataSource");
            GetDataSourceResponse getDataSourceResponse = (GetDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getDataSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFunctionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFunction");
            GetFunctionResponse getFunctionResponse = (GetFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFunction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFunctionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFunctionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getFunctionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphqlApiResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGraphqlApi");
            GetGraphqlApiResponse getGraphqlApiResponse = (GetGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraphqlApi").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGraphqlApiRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGraphqlApiResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getGraphqlApiRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) throws GraphQlSchemaException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIntrospectionSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIntrospectionSchema");
            GetIntrospectionSchemaResponse getIntrospectionSchemaResponse = (GetIntrospectionSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIntrospectionSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIntrospectionSchemaRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetIntrospectionSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIntrospectionSchemaResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getIntrospectionSchemaRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResolverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResolver");
            GetResolverResponse getResolverResponse = (GetResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResolver").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResolverRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResolverResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getResolverRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaCreationStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSchemaCreationStatus");
            GetSchemaCreationStatusResponse getSchemaCreationStatusResponse = (GetSchemaCreationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchemaCreationStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSchemaCreationStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSchemaCreationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSchemaCreationStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getSchemaCreationStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetType");
            GetTypeResponse getTypeResponse = (GetTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, getTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApiKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApiKeys");
            ListApiKeysResponse listApiKeysResponse = (ListApiKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApiKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApiKeysRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListApiKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApiKeysResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listApiKeysRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataSources");
            ListDataSourcesResponse listDataSourcesResponse = (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataSourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listDataSourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFunctionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFunctions");
            ListFunctionsResponse listFunctionsResponse = (ListFunctionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFunctions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFunctionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListFunctionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFunctionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listFunctionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphqlApisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGraphqlApis");
            ListGraphqlApisResponse listGraphqlApisResponse = (ListGraphqlApisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphqlApis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGraphqlApisRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListGraphqlApisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGraphqlApisResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listGraphqlApisRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResolvers");
            ListResolversResponse listResolversResponse = (ListResolversResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolvers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResolversRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListResolversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResolversResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listResolversRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResolversByFunctionResponse listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversByFunctionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResolversByFunction");
            ListResolversByFunctionResponse listResolversByFunctionResponse = (ListResolversByFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolversByFunction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResolversByFunctionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListResolversByFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResolversByFunctionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listResolversByFunctionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypes");
            ListTypesResponse listTypesResponse = (ListTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, listTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaCreationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSchemaCreation");
            StartSchemaCreationResponse startSchemaCreationResponse = (StartSchemaCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaCreation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSchemaCreationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartSchemaCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSchemaCreationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, startSchemaCreationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiCacheResponse updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiCacheResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApiCache");
            UpdateApiCacheResponse updateApiCacheResponse = (UpdateApiCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiCache").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApiCacheRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiCacheResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateApiCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws BadRequestException, NotFoundException, UnauthorizedException, LimitExceededException, InternalFailureException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApiKey");
            UpdateApiKeyResponse updateApiKeyResponse = (UpdateApiKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApiKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateApiKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataSource");
            UpdateDataSourceResponse updateDataSourceResponse = (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateDataSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFunctionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFunction");
            UpdateFunctionResponse updateFunctionResponse = (UpdateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFunction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFunctionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFunctionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateFunctionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGraphqlApiResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGraphqlApi");
            UpdateGraphqlApiResponse updateGraphqlApiResponse = (UpdateGraphqlApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGraphqlApi").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGraphqlApiRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGraphqlApiResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateGraphqlApiRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest) throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResolverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResolver");
            UpdateResolverResponse updateResolverResponse = (UpdateResolverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResolver").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResolverRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResolverResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateResolverRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateType");
            UpdateTypeResponse updateTypeResponse = (UpdateTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAppSyncClient.resolveMetricPublishers(this.clientConfiguration, updateTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppSyncException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").exceptionBuilderSupplier(GraphQlSchemaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").exceptionBuilderSupplier(ApiLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

