/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.ApiCacheType;
import software.amazon.awssdk.services.appsync.model.ApiCachingBehavior;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiCacheRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateApiCacheRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::apiId)).setter(CreateApiCacheRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::ttl)).setter(CreateApiCacheRequest.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::transitEncryptionEnabled)).setter(CreateApiCacheRequest.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::atRestEncryptionEnabled)).setter(CreateApiCacheRequest.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> API_CACHING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::apiCachingBehaviorAsString)).setter(CreateApiCacheRequest.setter(Builder::apiCachingBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCachingBehavior").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateApiCacheRequest.getter(CreateApiCacheRequest::typeAsString)).setter(CreateApiCacheRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, TTL_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, API_CACHING_BEHAVIOR_FIELD, TYPE_FIELD));
    private final String apiId;
    private final Long ttl;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String apiCachingBehavior;
    private final String type;

    private CreateApiCacheRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.ttl = builder.ttl;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.apiCachingBehavior = builder.apiCachingBehavior;
        this.type = builder.type;
    }

    public String apiId() {
        return this.apiId;
    }

    public Long ttl() {
        return this.ttl;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public ApiCachingBehavior apiCachingBehavior() {
        return ApiCachingBehavior.fromValue(this.apiCachingBehavior);
    }

    public String apiCachingBehaviorAsString() {
        return this.apiCachingBehavior;
    }

    public ApiCacheType type() {
        return ApiCacheType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCachingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiCacheRequest)) {
            return false;
        }
        CreateApiCacheRequest other = (CreateApiCacheRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.apiCachingBehaviorAsString(), other.apiCachingBehaviorAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateApiCacheRequest").add("ApiId", (Object)this.apiId()).add("Ttl", (Object)this.ttl()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("ApiCachingBehavior", (Object)this.apiCachingBehaviorAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "transitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "atRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "apiCachingBehavior": {
                return Optional.ofNullable(clazz.cast(this.apiCachingBehaviorAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiCacheRequest, T> g) {
        return obj -> g.apply((CreateApiCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private Long ttl;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String apiCachingBehavior;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiCacheRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.ttl(model.ttl);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.apiCachingBehavior(model.apiCachingBehavior);
            this.type(model.type);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final Long getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getApiCachingBehavior() {
            return this.apiCachingBehavior;
        }

        @Override
        public final Builder apiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
            return this;
        }

        @Override
        public final Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior) {
            this.apiCachingBehavior(apiCachingBehavior == null ? null : apiCachingBehavior.toString());
            return this;
        }

        public final void setApiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApiCacheType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiCacheRequest build() {
            return new CreateApiCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiCacheRequest> {
        public Builder apiId(String var1);

        public Builder ttl(Long var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder apiCachingBehavior(String var1);

        public Builder apiCachingBehavior(ApiCachingBehavior var1);

        public Builder type(String var1);

        public Builder type(ApiCacheType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

