/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTypeRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateTypeRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTypeRequest.getter(CreateTypeRequest::apiId)).setter(CreateTypeRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTypeRequest.getter(CreateTypeRequest::definition)).setter(CreateTypeRequest.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTypeRequest.getter(CreateTypeRequest::formatAsString)).setter(CreateTypeRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, DEFINITION_FIELD, FORMAT_FIELD));
    private final String apiId;
    private final String definition;
    private final String format;

    private CreateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.definition = builder.definition;
        this.format = builder.format;
    }

    public String apiId() {
        return this.apiId;
    }

    public String definition() {
        return this.definition;
    }

    public TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypeRequest)) {
            return false;
        }
        CreateTypeRequest other = (CreateTypeRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.formatAsString(), other.formatAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateTypeRequest").add("ApiId", (Object)this.apiId()).add("Definition", (Object)this.definition()).add("Format", (Object)this.formatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTypeRequest, T> g) {
        return obj -> g.apply((CreateTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String definition;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypeRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.definition(model.definition);
            this.format(model.format);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTypeRequest build() {
            return new CreateTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTypeRequest> {
        public Builder apiId(String var1);

        public Builder definition(String var1);

        public Builder format(String var1);

        public Builder format(TypeDefinitionFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

