/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTypeRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, DeleteTypeRequest> {
    private final String apiId;
    private final String typeName;

    private DeleteTypeRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.typeName = builder.typeName;
    }

    public String apiId() {
        return this.apiId;
    }

    public String typeName() {
        return this.typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTypeRequest)) {
            return false;
        }
        DeleteTypeRequest other = (DeleteTypeRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.typeName(), other.typeName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteTypeRequest").add("ApiId", (Object)this.apiId()).add("TypeName", (Object)this.typeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "typeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTypeRequest model) {
            this.apiId(model.apiId);
            this.typeName(model.typeName);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteTypeRequest build() {
            return new DeleteTypeRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, DeleteTypeRequest> {
        public Builder apiId(String var1);

        public Builder typeName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

