/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTypeRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateTypeRequest> {
    private final String apiId;
    private final String definition;
    private final String format;

    private CreateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.definition = builder.definition;
        this.format = builder.format;
    }

    public String apiId() {
        return this.apiId;
    }

    public String definition() {
        return this.definition;
    }

    public TypeDefinitionFormat format() {
        return TypeDefinitionFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypeRequest)) {
            return false;
        }
        CreateTypeRequest other = (CreateTypeRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.formatString(), other.formatString());
    }

    public String toString() {
        return ToString.builder((String)"CreateTypeRequest").add("ApiId", (Object)this.apiId()).add("Definition", (Object)this.definition()).add("Format", (Object)this.formatString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "definition": {
                return Optional.of(clazz.cast(this.definition()));
            }
            case "format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String definition;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypeRequest model) {
            this.apiId(model.apiId);
            this.definition(model.definition);
            this.format(model.format);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getDefinition() {
            return this.definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TypeDefinitionFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTypeRequest build() {
            return new CreateTypeRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, CreateTypeRequest> {
        public Builder apiId(String var1);

        public Builder definition(String var1);

        public Builder format(String var1);

        public Builder format(TypeDefinitionFormat var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

