/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthenticationType {
    API_KEY("API_KEY"),
    AWS_IAM("AWS_IAM"),
    AMAZON_COGNITO_USER_POOLS("AMAZON_COGNITO_USER_POOLS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthenticationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationType> knownValues() {
        return Stream.of(AuthenticationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

