/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.services.appsync.transform.UserPoolConfigUnmarshaller;

public class GraphqlApiUnmarshaller
implements Unmarshaller<GraphqlApi, JsonUnmarshallerContext> {
    private static final GraphqlApiUnmarshaller INSTANCE = new GraphqlApiUnmarshaller();

    public GraphqlApi unmarshall(JsonUnmarshallerContext context) throws Exception {
        GraphqlApi.Builder graphqlApiBuilder = GraphqlApi.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("apiId", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.apiId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("authenticationType", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.authenticationType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("userPoolConfig", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.userPoolConfig(UserPoolConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("uris", targetDepth)) {
                    context.nextToken();
                    graphqlApiBuilder.uris(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GraphqlApi)graphqlApiBuilder.build();
    }

    public static GraphqlApiUnmarshaller getInstance() {
        return INSTANCE;
    }
}

