/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig;

public class DynamodbDataSourceConfigUnmarshaller
implements Unmarshaller<DynamodbDataSourceConfig, JsonUnmarshallerContext> {
    private static final DynamodbDataSourceConfigUnmarshaller INSTANCE = new DynamodbDataSourceConfigUnmarshaller();

    public DynamodbDataSourceConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamodbDataSourceConfig.Builder dynamodbDataSourceConfigBuilder = DynamodbDataSourceConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("tableName", targetDepth)) {
                    context.nextToken();
                    dynamodbDataSourceConfigBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    dynamodbDataSourceConfigBuilder.awsRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("useCallerCredentials", targetDepth)) {
                    context.nextToken();
                    dynamodbDataSourceConfigBuilder.useCallerCredentials((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DynamodbDataSourceConfig)dynamodbDataSourceConfigBuilder.build();
    }

    public static DynamodbDataSourceConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

