/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.appsync.model.Type;
import software.amazon.awssdk.services.appsync.model.TypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTypesResponse> {
    private final List<Type> types;
    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        this.types = builder.types;
        this.nextToken = builder.nextToken;
    }

    public List<Type> types() {
        return this.types;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.types());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse)((Object)obj);
        return Objects.equals(this.types(), other.types()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.types() != null) {
            sb.append("Types: ").append(this.types()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "types": {
                return Optional.of(clazz.cast(this.types()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Type> types;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            this.types(model.types);
            this.nextToken(model.nextToken);
        }

        public final Collection<Type.Builder> getTypes() {
            return this.types != null ? (Collection)this.types.stream().map(Type::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder types(Collection<Type> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(Type ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<Type.BuilderImpl> types) {
            this.types = TypeListCopier.copyFromBuilder(types);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTypesResponse> {
        public Builder types(Collection<Type> var1);

        public Builder types(Type ... var1);

        public Builder nextToken(String var1);
    }
}

