/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.appsync.model.GraphqlApi;
import software.amazon.awssdk.services.appsync.model.GraphqlApisCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGraphqlApisResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGraphqlApisResponse> {
    private final List<GraphqlApi> graphqlApis;
    private final String nextToken;

    private ListGraphqlApisResponse(BuilderImpl builder) {
        this.graphqlApis = builder.graphqlApis;
        this.nextToken = builder.nextToken;
    }

    public List<GraphqlApi> graphqlApis() {
        return this.graphqlApis;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.graphqlApis());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphqlApisResponse)) {
            return false;
        }
        ListGraphqlApisResponse other = (ListGraphqlApisResponse)((Object)obj);
        return Objects.equals(this.graphqlApis(), other.graphqlApis()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.graphqlApis() != null) {
            sb.append("GraphqlApis: ").append(this.graphqlApis()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphqlApis": {
                return Optional.of(clazz.cast(this.graphqlApis()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GraphqlApi> graphqlApis;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphqlApisResponse model) {
            this.graphqlApis(model.graphqlApis);
            this.nextToken(model.nextToken);
        }

        public final Collection<GraphqlApi.Builder> getGraphqlApis() {
            return this.graphqlApis != null ? (Collection)this.graphqlApis.stream().map(GraphqlApi::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder graphqlApis(Collection<GraphqlApi> graphqlApis) {
            this.graphqlApis = GraphqlApisCopier.copy(graphqlApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphqlApis(GraphqlApi ... graphqlApis) {
            this.graphqlApis(Arrays.asList(graphqlApis));
            return this;
        }

        public final void setGraphqlApis(Collection<GraphqlApi.BuilderImpl> graphqlApis) {
            this.graphqlApis = GraphqlApisCopier.copyFromBuilder(graphqlApis);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListGraphqlApisResponse build() {
            return new ListGraphqlApisResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGraphqlApisResponse> {
        public Builder graphqlApis(Collection<GraphqlApi> var1);

        public Builder graphqlApis(GraphqlApi ... var1);

        public Builder nextToken(String var1);
    }
}

