/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.appsync.model.DataSource;
import software.amazon.awssdk.services.appsync.model.DataSourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDataSourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDataSourcesResponse> {
    private final List<DataSource> dataSources;
    private final String nextToken;

    private ListDataSourcesResponse(BuilderImpl builder) {
        this.dataSources = builder.dataSources;
        this.nextToken = builder.nextToken;
    }

    public List<DataSource> dataSources() {
        return this.dataSources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesResponse)) {
            return false;
        }
        ListDataSourcesResponse other = (ListDataSourcesResponse)((Object)obj);
        return Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataSources() != null) {
            sb.append("DataSources: ").append(this.dataSources()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSources": {
                return Optional.of(clazz.cast(this.dataSources()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSource> dataSources;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourcesResponse model) {
            this.dataSources(model.dataSources);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return this.dataSources != null ? (Collection)this.dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDataSourcesResponse build() {
            return new ListDataSourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDataSourcesResponse> {
        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder nextToken(String var1);
    }
}

