/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIntrospectionSchemaResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIntrospectionSchemaResponse> {
    private final ByteBuffer schema;

    private GetIntrospectionSchemaResponse(BuilderImpl builder) {
        this.schema = builder.schema;
    }

    public ByteBuffer schema() {
        return this.schema == null ? null : this.schema.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaResponse)) {
            return false;
        }
        GetIntrospectionSchemaResponse other = (GetIntrospectionSchemaResponse)((Object)obj);
        return Objects.equals(this.schema(), other.schema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schema() != null) {
            sb.append("Schema: ").append(this.schema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schema": {
                return Optional.of(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaResponse model) {
            this.schema(model.schema);
        }

        public final ByteBuffer getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(ByteBuffer schema) {
            this.schema = StandardMemberCopier.copy((ByteBuffer)schema);
            return this;
        }

        public final void setSchema(ByteBuffer schema) {
            this.schema = StandardMemberCopier.copy((ByteBuffer)schema);
        }

        public GetIntrospectionSchemaResponse build() {
            return new GetIntrospectionSchemaResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIntrospectionSchemaResponse> {
        public Builder schema(ByteBuffer var1);
    }
}

