/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appsync.model.OutputType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIntrospectionSchemaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetIntrospectionSchemaRequest> {
    private final String apiId;
    private final String format;

    private GetIntrospectionSchemaRequest(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.format = builder.format;
    }

    public String apiId() {
        return this.apiId;
    }

    public OutputType format() {
        return OutputType.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntrospectionSchemaRequest)) {
            return false;
        }
        GetIntrospectionSchemaRequest other = (GetIntrospectionSchemaRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.formatString(), other.formatString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.apiId() != null) {
            sb.append("ApiId: ").append(this.apiId()).append(",");
        }
        if (this.formatString() != null) {
            sb.append("Format: ").append(this.formatString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntrospectionSchemaRequest model) {
            this.apiId(model.apiId);
            this.format(model.format);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(OutputType format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public GetIntrospectionSchemaRequest build() {
            return new GetIntrospectionSchemaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIntrospectionSchemaRequest> {
        public Builder apiId(String var1);

        public Builder format(String var1);

        public Builder format(OutputType var1);
    }
}

