/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appsync.model.DataSourceType;
import software.amazon.awssdk.services.appsync.model.DynamodbDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig;
import software.amazon.awssdk.services.appsync.model.LambdaDataSourceConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private final String apiId;
    private final String name;
    private final String description;
    private final String type;
    private final String serviceRoleArn;
    private final DynamodbDataSourceConfig dynamodbConfig;
    private final LambdaDataSourceConfig lambdaConfig;
    private final ElasticsearchDataSourceConfig elasticsearchConfig;

    private CreateDataSourceRequest(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.dynamodbConfig = builder.dynamodbConfig;
        this.lambdaConfig = builder.lambdaConfig;
        this.elasticsearchConfig = builder.elasticsearchConfig;
    }

    public String apiId() {
        return this.apiId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public DynamodbDataSourceConfig dynamodbConfig() {
        return this.dynamodbConfig;
    }

    public LambdaDataSourceConfig lambdaConfig() {
        return this.lambdaConfig;
    }

    public ElasticsearchDataSourceConfig elasticsearchConfig() {
        return this.elasticsearchConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamodbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.dynamodbConfig(), other.dynamodbConfig()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.elasticsearchConfig(), other.elasticsearchConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.apiId() != null) {
            sb.append("ApiId: ").append(this.apiId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.dynamodbConfig() != null) {
            sb.append("DynamodbConfig: ").append(this.dynamodbConfig()).append(",");
        }
        if (this.lambdaConfig() != null) {
            sb.append("LambdaConfig: ").append(this.lambdaConfig()).append(",");
        }
        if (this.elasticsearchConfig() != null) {
            sb.append("ElasticsearchConfig: ").append(this.elasticsearchConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.of(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "serviceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "dynamodbConfig": {
                return Optional.of(clazz.cast(this.dynamodbConfig()));
            }
            case "lambdaConfig": {
                return Optional.of(clazz.cast(this.lambdaConfig()));
            }
            case "elasticsearchConfig": {
                return Optional.of(clazz.cast(this.elasticsearchConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private String description;
        private String type;
        private String serviceRoleArn;
        private DynamodbDataSourceConfig dynamodbConfig;
        private LambdaDataSourceConfig lambdaConfig;
        private ElasticsearchDataSourceConfig elasticsearchConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            this.apiId(model.apiId);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.serviceRoleArn(model.serviceRoleArn);
            this.dynamodbConfig(model.dynamodbConfig);
            this.lambdaConfig(model.lambdaConfig);
            this.elasticsearchConfig(model.elasticsearchConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final DynamodbDataSourceConfig.Builder getDynamodbConfig() {
            return this.dynamodbConfig != null ? this.dynamodbConfig.toBuilder() : null;
        }

        @Override
        public final Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig;
            return this;
        }

        public final void setDynamodbConfig(DynamodbDataSourceConfig.BuilderImpl dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig != null ? dynamodbConfig.build() : null;
        }

        public final LambdaDataSourceConfig.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaDataSourceConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final ElasticsearchDataSourceConfig.Builder getElasticsearchConfig() {
            return this.elasticsearchConfig != null ? this.elasticsearchConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        public final void setElasticsearchConfig(ElasticsearchDataSourceConfig.BuilderImpl elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig != null ? elasticsearchConfig.build() : null;
        }

        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder serviceRoleArn(String var1);

        public Builder dynamodbConfig(DynamodbDataSourceConfig var1);

        default public Builder dynamodbConfig(Consumer<DynamodbDataSourceConfig.Builder> dynamodbConfig) {
            return this.dynamodbConfig((DynamodbDataSourceConfig)((DynamodbDataSourceConfig.Builder)DynamodbDataSourceConfig.builder().apply(dynamodbConfig)).build());
        }

        public Builder lambdaConfig(LambdaDataSourceConfig var1);

        default public Builder lambdaConfig(Consumer<LambdaDataSourceConfig.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaDataSourceConfig)((LambdaDataSourceConfig.Builder)LambdaDataSourceConfig.builder().apply(lambdaConfig)).build());
        }

        public Builder elasticsearchConfig(ElasticsearchDataSourceConfig var1);

        default public Builder elasticsearchConfig(Consumer<ElasticsearchDataSourceConfig.Builder> elasticsearchConfig) {
            return this.elasticsearchConfig((ElasticsearchDataSourceConfig)((ElasticsearchDataSourceConfig.Builder)ElasticsearchDataSourceConfig.builder().apply(elasticsearchConfig)).build());
        }
    }
}

