/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGraphqlApiRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logConfig").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authenticationType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> USERPOOLCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userPoolConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OPENIDCONNECTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openIDConnectConfig").isBinary(false).build();
    private static final CreateGraphqlApiRequestModelMarshaller INSTANCE = new CreateGraphqlApiRequestModelMarshaller();

    private CreateGraphqlApiRequestModelMarshaller() {
    }

    public static CreateGraphqlApiRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGraphqlApiRequest createGraphqlApiRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createGraphqlApiRequest), (String)"createGraphqlApiRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGraphqlApiRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createGraphqlApiRequest.logConfig(), LOGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createGraphqlApiRequest.authenticationTypeAsString(), AUTHENTICATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)createGraphqlApiRequest.userPoolConfig(), USERPOOLCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createGraphqlApiRequest.openIDConnectConfig(), OPENIDCONNECTCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

