/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApiKeyMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Long> EXPIRES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expires").isBinary(false).build();
    private static final ApiKeyMarshaller INSTANCE = new ApiKeyMarshaller();

    private ApiKeyMarshaller() {
    }

    public static ApiKeyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApiKey apiKey, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)apiKey, (String)"apiKey");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)apiKey.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)apiKey.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)apiKey.expires(), EXPIRES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

