/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.services.appsync.model.ApiKeysCopier;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApiKeysResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListApiKeysResponse> {
    private final List<ApiKey> apiKeys;
    private final String nextToken;

    private ListApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.apiKeys = builder.apiKeys;
        this.nextToken = builder.nextToken;
    }

    public List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse)((Object)obj);
        return Objects.equals(this.apiKeys(), other.apiKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListApiKeysResponse").add("ApiKeys", this.apiKeys()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKeys": {
                return Optional.ofNullable(clazz.cast(this.apiKeys()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<ApiKey> apiKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            super(model);
            this.apiKeys(model.apiKeys);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApiKey.Builder> getApiKeys() {
            return this.apiKeys != null ? (Collection)this.apiKeys.stream().map(ApiKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apiKeys(Collection<ApiKey> apiKeys) {
            this.apiKeys = ApiKeysCopier.copy(apiKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(ApiKey ... apiKeys) {
            this.apiKeys(Arrays.asList(apiKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(Consumer<ApiKey.Builder> ... apiKeys) {
            this.apiKeys(Stream.of(apiKeys).map(c -> (ApiKey)((ApiKey.Builder)ApiKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApiKeys(Collection<ApiKey.BuilderImpl> apiKeys) {
            this.apiKeys = ApiKeysCopier.copyFromBuilder(apiKeys);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    CopyableBuilder<Builder, ListApiKeysResponse> {
        public Builder apiKeys(Collection<ApiKey> var1);

        public Builder apiKeys(ApiKey ... var1);

        public Builder apiKeys(Consumer<ApiKey.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

