/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.transform.HttpDataSourceConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpDataSourceConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, HttpDataSourceConfig> {
    private final String endpoint;

    private HttpDataSourceConfig(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpDataSourceConfig)) {
            return false;
        }
        HttpDataSourceConfig other = (HttpDataSourceConfig)obj;
        return Objects.equals(this.endpoint(), other.endpoint());
    }

    public String toString() {
        return ToString.builder((String)"HttpDataSourceConfig").add("Endpoint", (Object)this.endpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpDataSourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpDataSourceConfig model) {
            this.endpoint(model.endpoint);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public HttpDataSourceConfig build() {
            return new HttpDataSourceConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HttpDataSourceConfig> {
        public Builder endpoint(String var1);
    }
}

