/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiKeyRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, CreateApiKeyRequest> {
    private final String apiId;
    private final String description;
    private final Long expires;

    private CreateApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.description = builder.description;
        this.expires = builder.expires;
    }

    public String apiId() {
        return this.apiId;
    }

    public String description() {
        return this.description;
    }

    public Long expires() {
        return this.expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyRequest)) {
            return false;
        }
        CreateApiKeyRequest other = (CreateApiKeyRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.expires(), other.expires());
    }

    public String toString() {
        return ToString.builder((String)"CreateApiKeyRequest").add("ApiId", (Object)this.apiId()).add("Description", (Object)this.description()).add("Expires", (Object)this.expires()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String apiId;
        private String description;
        private Long expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.description(model.description);
            this.expires(model.expires);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Long getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Long expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Long expires) {
            this.expires = expires;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiKeyRequest build() {
            return new CreateApiKeyRequest(this);
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    CopyableBuilder<Builder, CreateApiKeyRequest> {
        public Builder apiId(String var1);

        public Builder description(String var1);

        public Builder expires(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

