/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appsync.model.Type;

public class TypeUnmarshaller
implements Unmarshaller<Type, JsonUnmarshallerContext> {
    private static final TypeUnmarshaller INSTANCE = new TypeUnmarshaller();

    public Type unmarshall(JsonUnmarshallerContext context) throws Exception {
        Type.Builder typeBuilder = Type.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    typeBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    typeBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    typeBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("definition", targetDepth)) {
                    context.nextToken();
                    typeBuilder.definition((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("format", targetDepth)) {
                    context.nextToken();
                    typeBuilder.format((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Type)typeBuilder.build();
    }

    public static TypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

