/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.transform.ElasticsearchDataSourceConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDataSourceConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDataSourceConfig> {
    private final String endpoint;
    private final String awsRegion;

    private ElasticsearchDataSourceConfig(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.awsRegion = builder.awsRegion;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDataSourceConfig)) {
            return false;
        }
        ElasticsearchDataSourceConfig other = (ElasticsearchDataSourceConfig)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchDataSourceConfig").add("Endpoint", (Object)this.endpoint()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDataSourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDataSourceConfig model) {
            this.endpoint(model.endpoint);
            this.awsRegion(model.awsRegion);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public ElasticsearchDataSourceConfig build() {
            return new ElasticsearchDataSourceConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDataSourceConfig> {
        public Builder endpoint(String var1);

        public Builder awsRegion(String var1);
    }
}

