/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamingUrlRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateStreamingUrlRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::stackName)).setter(CreateStreamingUrlRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::fleetName)).setter(CreateStreamingUrlRequest.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::userId)).setter(CreateStreamingUrlRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::applicationId)).setter(CreateStreamingUrlRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<Long> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::validity)).setter(CreateStreamingUrlRequest.setter(Builder::validity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<String> SESSION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStreamingUrlRequest.getter(CreateStreamingUrlRequest::sessionContext)).setter(CreateStreamingUrlRequest.setter(Builder::sessionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, FLEET_NAME_FIELD, USER_ID_FIELD, APPLICATION_ID_FIELD, VALIDITY_FIELD, SESSION_CONTEXT_FIELD));
    private final String stackName;
    private final String fleetName;
    private final String userId;
    private final String applicationId;
    private final Long validity;
    private final String sessionContext;

    private CreateStreamingUrlRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.applicationId = builder.applicationId;
        this.validity = builder.validity;
        this.sessionContext = builder.sessionContext;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String userId() {
        return this.userId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Long validity() {
        return this.validity;
    }

    public String sessionContext() {
        return this.sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingUrlRequest)) {
            return false;
        }
        CreateStreamingUrlRequest other = (CreateStreamingUrlRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.sessionContext(), other.sessionContext());
    }

    public String toString() {
        return ToString.builder((String)"CreateStreamingUrlRequest").add("StackName", (Object)this.stackName()).add("FleetName", (Object)this.fleetName()).add("UserId", (Object)this.userId()).add("ApplicationId", (Object)this.applicationId()).add("Validity", (Object)this.validity()).add("SessionContext", (Object)this.sessionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "SessionContext": {
                return Optional.ofNullable(clazz.cast(this.sessionContext()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingUrlRequest, T> g) {
        return obj -> g.apply((CreateStreamingUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String fleetName;
        private String userId;
        private String applicationId;
        private Long validity;
        private String sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingUrlRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.fleetName(model.fleetName);
            this.userId(model.userId);
            this.applicationId(model.applicationId);
            this.validity(model.validity);
            this.sessionContext(model.sessionContext);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Long getValidity() {
            return this.validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        public final String getSessionContext() {
            return this.sessionContext;
        }

        @Override
        public final Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingUrlRequest build() {
            return new CreateStreamingUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamingUrlRequest> {
        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder userId(String var1);

        public Builder applicationId(String var1);

        public Builder validity(Long var1);

        public Builder sessionContext(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

