/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageBuilderState {
    PENDING("PENDING"),
    UPDATING_AGENT("UPDATING_AGENT"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    REBOOTING("REBOOTING"),
    SNAPSHOTTING("SNAPSHOTTING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UPDATING("UPDATING"),
    PENDING_QUALIFICATION("PENDING_QUALIFICATION"),
    PENDING_SYNCING_APPS("PENDING_SYNCING_APPS"),
    SYNCING_APPS("SYNCING_APPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageBuilderState> VALUE_MAP;
    private final String value;

    private ImageBuilderState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageBuilderState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageBuilderState> knownValues() {
        EnumSet<ImageBuilderState> knownValues = EnumSet.allOf(ImageBuilderState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageBuilderState.class, ImageBuilderState::toString);
    }
}

