/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttribute;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderAttributesCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppBlockBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateAppBlockBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::name)).setter(UpdateAppBlockBuilderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::description)).setter(UpdateAppBlockBuilderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::displayName)).setter(UpdateAppBlockBuilderRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::platformAsString)).setter(UpdateAppBlockBuilderRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::instanceType)).setter(UpdateAppBlockBuilderRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::vpcConfig)).setter(UpdateAppBlockBuilderRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDefaultInternetAccess").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::enableDefaultInternetAccess)).setter(UpdateAppBlockBuilderRequest.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::iamRoleArn)).setter(UpdateAppBlockBuilderRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::accessEndpoints)).setter(UpdateAppBlockBuilderRequest.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToDelete").getter(UpdateAppBlockBuilderRequest.getter(UpdateAppBlockBuilderRequest::attributesToDeleteAsStrings)).setter(UpdateAppBlockBuilderRequest.setter(Builder::attributesToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, PLATFORM_FIELD, INSTANCE_TYPE_FIELD, VPC_CONFIG_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, IAM_ROLE_ARN_FIELD, ACCESS_ENDPOINTS_FIELD, ATTRIBUTES_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAppBlockBuilderRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String displayName;
    private final String platform;
    private final String instanceType;
    private final VpcConfig vpcConfig;
    private final Boolean enableDefaultInternetAccess;
    private final String iamRoleArn;
    private final List<AccessEndpoint> accessEndpoints;
    private final List<String> attributesToDelete;

    private UpdateAppBlockBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.platform = builder.platform;
        this.instanceType = builder.instanceType;
        this.vpcConfig = builder.vpcConfig;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.iamRoleArn = builder.iamRoleArn;
        this.accessEndpoints = builder.accessEndpoints;
        this.attributesToDelete = builder.attributesToDelete;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public final List<AppBlockBuilderAttribute> attributesToDelete() {
        return AppBlockBuilderAttributesCopier.copyStringToEnum(this.attributesToDelete);
    }

    public final boolean hasAttributesToDelete() {
        return this.attributesToDelete != null && !(this.attributesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppBlockBuilderRequest)) {
            return false;
        }
        UpdateAppBlockBuilderRequest other = (UpdateAppBlockBuilderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints()) && this.hasAttributesToDelete() == other.hasAttributesToDelete() && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppBlockBuilderRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("Platform", (Object)this.platformAsString()).add("InstanceType", (Object)this.instanceType()).add("VpcConfig", (Object)this.vpcConfig()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("IamRoleArn", (Object)this.iamRoleArn()).add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).add("AttributesToDelete", this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("EnableDefaultInternetAccess", ENABLE_DEFAULT_INTERNET_ACCESS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("AccessEndpoints", ACCESS_ENDPOINTS_FIELD);
        map.put("AttributesToDelete", ATTRIBUTES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppBlockBuilderRequest, T> g) {
        return obj -> g.apply((UpdateAppBlockBuilderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private String platform;
        private String instanceType;
        private VpcConfig vpcConfig;
        private Boolean enableDefaultInternetAccess;
        private String iamRoleArn;
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppBlockBuilderRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.platform(model.platform);
            this.instanceType(model.instanceType);
            this.vpcConfig(model.vpcConfig);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.iamRoleArn(model.iamRoleArn);
            this.accessEndpoints(model.accessEndpoints);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (this.attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<AppBlockBuilderAttribute> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(AppBlockBuilderAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppBlockBuilderRequest build() {
            return new UpdateAppBlockBuilderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppBlockBuilderRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder instanceType(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder iamRoleArn(String var1);

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<AppBlockBuilderAttribute> var1);

        public Builder attributesToDelete(AppBlockBuilderAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

