/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUpdatedImageRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateUpdatedImageRequest> {
    private static final SdkField<String> EXISTING_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingImageName").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::existingImageName)).setter(CreateUpdatedImageRequest.setter(Builder::existingImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingImageName").build()}).build();
    private static final SdkField<String> NEW_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newImageName").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::newImageName)).setter(CreateUpdatedImageRequest.setter(Builder::newImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageName").build()}).build();
    private static final SdkField<String> NEW_IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newImageDescription").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::newImageDescription)).setter(CreateUpdatedImageRequest.setter(Builder::newImageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageDescription").build()}).build();
    private static final SdkField<String> NEW_IMAGE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newImageDisplayName").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::newImageDisplayName)).setter(CreateUpdatedImageRequest.setter(Builder::newImageDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageDisplayName").build()}).build();
    private static final SdkField<Map<String, String>> NEW_IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("newImageTags").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::newImageTags)).setter(CreateUpdatedImageRequest.setter(Builder::newImageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dryRun").getter(CreateUpdatedImageRequest.getter(CreateUpdatedImageRequest::dryRun)).setter(CreateUpdatedImageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXISTING_IMAGE_NAME_FIELD, NEW_IMAGE_NAME_FIELD, NEW_IMAGE_DESCRIPTION_FIELD, NEW_IMAGE_DISPLAY_NAME_FIELD, NEW_IMAGE_TAGS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateUpdatedImageRequest.memberNameToFieldInitializer();
    private final String existingImageName;
    private final String newImageName;
    private final String newImageDescription;
    private final String newImageDisplayName;
    private final Map<String, String> newImageTags;
    private final Boolean dryRun;

    private CreateUpdatedImageRequest(BuilderImpl builder) {
        super(builder);
        this.existingImageName = builder.existingImageName;
        this.newImageName = builder.newImageName;
        this.newImageDescription = builder.newImageDescription;
        this.newImageDisplayName = builder.newImageDisplayName;
        this.newImageTags = builder.newImageTags;
        this.dryRun = builder.dryRun;
    }

    public final String existingImageName() {
        return this.existingImageName;
    }

    public final String newImageName() {
        return this.newImageName;
    }

    public final String newImageDescription() {
        return this.newImageDescription;
    }

    public final String newImageDisplayName() {
        return this.newImageDisplayName;
    }

    public final boolean hasNewImageTags() {
        return this.newImageTags != null && !(this.newImageTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> newImageTags() {
        return this.newImageTags;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.existingImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newImageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.newImageDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewImageTags() ? this.newImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUpdatedImageRequest)) {
            return false;
        }
        CreateUpdatedImageRequest other = (CreateUpdatedImageRequest)((Object)obj);
        return Objects.equals(this.existingImageName(), other.existingImageName()) && Objects.equals(this.newImageName(), other.newImageName()) && Objects.equals(this.newImageDescription(), other.newImageDescription()) && Objects.equals(this.newImageDisplayName(), other.newImageDisplayName()) && this.hasNewImageTags() == other.hasNewImageTags() && Objects.equals(this.newImageTags(), other.newImageTags()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUpdatedImageRequest").add("ExistingImageName", (Object)this.existingImageName()).add("NewImageName", (Object)this.newImageName()).add("NewImageDescription", (Object)this.newImageDescription()).add("NewImageDisplayName", (Object)this.newImageDisplayName()).add("NewImageTags", this.hasNewImageTags() ? this.newImageTags() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "existingImageName": {
                return Optional.ofNullable(clazz.cast(this.existingImageName()));
            }
            case "newImageName": {
                return Optional.ofNullable(clazz.cast(this.newImageName()));
            }
            case "newImageDescription": {
                return Optional.ofNullable(clazz.cast(this.newImageDescription()));
            }
            case "newImageDisplayName": {
                return Optional.ofNullable(clazz.cast(this.newImageDisplayName()));
            }
            case "newImageTags": {
                return Optional.ofNullable(clazz.cast(this.newImageTags()));
            }
            case "dryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("existingImageName", EXISTING_IMAGE_NAME_FIELD);
        map.put("newImageName", NEW_IMAGE_NAME_FIELD);
        map.put("newImageDescription", NEW_IMAGE_DESCRIPTION_FIELD);
        map.put("newImageDisplayName", NEW_IMAGE_DISPLAY_NAME_FIELD);
        map.put("newImageTags", NEW_IMAGE_TAGS_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUpdatedImageRequest, T> g) {
        return obj -> g.apply((CreateUpdatedImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String existingImageName;
        private String newImageName;
        private String newImageDescription;
        private String newImageDisplayName;
        private Map<String, String> newImageTags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUpdatedImageRequest model) {
            super(model);
            this.existingImageName(model.existingImageName);
            this.newImageName(model.newImageName);
            this.newImageDescription(model.newImageDescription);
            this.newImageDisplayName(model.newImageDisplayName);
            this.newImageTags(model.newImageTags);
            this.dryRun(model.dryRun);
        }

        public final String getExistingImageName() {
            return this.existingImageName;
        }

        public final void setExistingImageName(String existingImageName) {
            this.existingImageName = existingImageName;
        }

        @Override
        public final Builder existingImageName(String existingImageName) {
            this.existingImageName = existingImageName;
            return this;
        }

        public final String getNewImageName() {
            return this.newImageName;
        }

        public final void setNewImageName(String newImageName) {
            this.newImageName = newImageName;
        }

        @Override
        public final Builder newImageName(String newImageName) {
            this.newImageName = newImageName;
            return this;
        }

        public final String getNewImageDescription() {
            return this.newImageDescription;
        }

        public final void setNewImageDescription(String newImageDescription) {
            this.newImageDescription = newImageDescription;
        }

        @Override
        public final Builder newImageDescription(String newImageDescription) {
            this.newImageDescription = newImageDescription;
            return this;
        }

        public final String getNewImageDisplayName() {
            return this.newImageDisplayName;
        }

        public final void setNewImageDisplayName(String newImageDisplayName) {
            this.newImageDisplayName = newImageDisplayName;
        }

        @Override
        public final Builder newImageDisplayName(String newImageDisplayName) {
            this.newImageDisplayName = newImageDisplayName;
            return this;
        }

        public final Map<String, String> getNewImageTags() {
            if (this.newImageTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.newImageTags;
        }

        public final void setNewImageTags(Map<String, String> newImageTags) {
            this.newImageTags = TagsCopier.copy(newImageTags);
        }

        @Override
        public final Builder newImageTags(Map<String, String> newImageTags) {
            this.newImageTags = TagsCopier.copy(newImageTags);
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUpdatedImageRequest build() {
            return new CreateUpdatedImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUpdatedImageRequest> {
        public Builder existingImageName(String var1);

        public Builder newImageName(String var1);

        public Builder newImageDescription(String var1);

        public Builder newImageDisplayName(String var1);

        public Builder newImageTags(Map<String, String> var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

