/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScriptDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScriptDetails> {
    private static final SdkField<S3Location> SCRIPT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScriptS3Location").getter(ScriptDetails.getter(ScriptDetails::scriptS3Location)).setter(ScriptDetails.setter(Builder::scriptS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptS3Location").build()}).build();
    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutablePath").getter(ScriptDetails.getter(ScriptDetails::executablePath)).setter(ScriptDetails.setter(Builder::executablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()}).build();
    private static final SdkField<String> EXECUTABLE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutableParameters").getter(ScriptDetails.getter(ScriptDetails::executableParameters)).setter(ScriptDetails.setter(Builder::executableParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutableParameters").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInSeconds").getter(ScriptDetails.getter(ScriptDetails::timeoutInSeconds)).setter(ScriptDetails.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_S3_LOCATION_FIELD, EXECUTABLE_PATH_FIELD, EXECUTABLE_PARAMETERS_FIELD, TIMEOUT_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScriptDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Location scriptS3Location;
    private final String executablePath;
    private final String executableParameters;
    private final Integer timeoutInSeconds;

    private ScriptDetails(BuilderImpl builder) {
        this.scriptS3Location = builder.scriptS3Location;
        this.executablePath = builder.executablePath;
        this.executableParameters = builder.executableParameters;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    public final S3Location scriptS3Location() {
        return this.scriptS3Location;
    }

    public final String executablePath() {
        return this.executablePath;
    }

    public final String executableParameters() {
        return this.executableParameters;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.executableParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptDetails)) {
            return false;
        }
        ScriptDetails other = (ScriptDetails)obj;
        return Objects.equals(this.scriptS3Location(), other.scriptS3Location()) && Objects.equals(this.executablePath(), other.executablePath()) && Objects.equals(this.executableParameters(), other.executableParameters()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ScriptDetails").add("ScriptS3Location", (Object)this.scriptS3Location()).add("ExecutablePath", (Object)this.executablePath()).add("ExecutableParameters", (Object)this.executableParameters()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScriptS3Location": {
                return Optional.ofNullable(clazz.cast(this.scriptS3Location()));
            }
            case "ExecutablePath": {
                return Optional.ofNullable(clazz.cast(this.executablePath()));
            }
            case "ExecutableParameters": {
                return Optional.ofNullable(clazz.cast(this.executableParameters()));
            }
            case "TimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScriptS3Location", SCRIPT_S3_LOCATION_FIELD);
        map.put("ExecutablePath", EXECUTABLE_PATH_FIELD);
        map.put("ExecutableParameters", EXECUTABLE_PARAMETERS_FIELD);
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScriptDetails, T> g) {
        return obj -> g.apply((ScriptDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Location scriptS3Location;
        private String executablePath;
        private String executableParameters;
        private Integer timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptDetails model) {
            this.scriptS3Location(model.scriptS3Location);
            this.executablePath(model.executablePath);
            this.executableParameters(model.executableParameters);
            this.timeoutInSeconds(model.timeoutInSeconds);
        }

        public final S3Location.Builder getScriptS3Location() {
            return this.scriptS3Location != null ? this.scriptS3Location.toBuilder() : null;
        }

        public final void setScriptS3Location(S3Location.BuilderImpl scriptS3Location) {
            this.scriptS3Location = scriptS3Location != null ? scriptS3Location.build() : null;
        }

        @Override
        public final Builder scriptS3Location(S3Location scriptS3Location) {
            this.scriptS3Location = scriptS3Location;
            return this;
        }

        public final String getExecutablePath() {
            return this.executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getExecutableParameters() {
            return this.executableParameters;
        }

        public final void setExecutableParameters(String executableParameters) {
            this.executableParameters = executableParameters;
        }

        @Override
        public final Builder executableParameters(String executableParameters) {
            this.executableParameters = executableParameters;
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public ScriptDetails build() {
            return new ScriptDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScriptDetails> {
        public Builder scriptS3Location(S3Location var1);

        default public Builder scriptS3Location(Consumer<S3Location.Builder> scriptS3Location) {
            return this.scriptS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(scriptS3Location)).build());
        }

        public Builder executablePath(String var1);

        public Builder executableParameters(String var1);

        public Builder timeoutInSeconds(Integer var1);
    }
}

