/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.internal.UserAgentUtils;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;

public class DescribeImagesIterable
implements SdkIterable<DescribeImagesResponse> {
    private final AppStreamClient client;
    private final DescribeImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImagesIterable(AppStreamClient client, DescribeImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public Iterator<DescribeImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeImagesResponseFetcher
    implements SyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImagesResponse nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesIterable.this.client.describeImages(DescribeImagesIterable.this.firstRequest);
            }
            return DescribeImagesIterable.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

