/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.waiters.AppStreamAsyncWaiter;
import software.amazon.awssdk.services.appstream.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultAppStreamAsyncWaiter
implements AppStreamAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final AppStreamAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeFleetsResponse> fleetStartedWaiter;
    private final AsyncWaiter<DescribeFleetsResponse> fleetStoppedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultAppStreamAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AppStreamAsyncClient)AppStreamAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fleetStartedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFleetsResponse.class).acceptors(DefaultAppStreamAsyncWaiter.fleetStartedWaiterAcceptors())).overrideConfiguration(DefaultAppStreamAsyncWaiter.fleetStartedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.fleetStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFleetsResponse.class).acceptors(DefaultAppStreamAsyncWaiter.fleetStoppedWaiterAcceptors())).overrideConfiguration(DefaultAppStreamAsyncWaiter.fleetStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFleetsResponse>> waitUntilFleetStarted(DescribeFleetsRequest describeFleetsRequest) {
        return this.fleetStartedWaiter.runAsync(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFleetsResponse>> waitUntilFleetStarted(DescribeFleetsRequest describeFleetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetStartedWaiter.runAsync(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)), DefaultAppStreamAsyncWaiter.fleetStartedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFleetsResponse>> waitUntilFleetStopped(DescribeFleetsRequest describeFleetsRequest) {
        return this.fleetStoppedWaiter.runAsync(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFleetsResponse>> waitUntilFleetStopped(DescribeFleetsRequest describeFleetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetStoppedWaiter.runAsync(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)), DefaultAppStreamAsyncWaiter.fleetStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFleetsResponse>> fleetStartedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STOPPING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Fleets[].State=STOPPING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STOPPED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Fleets[].State=STOPPED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFleetsResponse>> fleetStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "STOPPED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STARTING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Fleets[].State=STARTING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "RUNNING"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Fleets[].State=RUNNING) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fleetStartedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fleetStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AppStreamAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AppStreamRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppStreamRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AppStreamAsyncWaiter.Builder {
        private AppStreamAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public AppStreamAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public AppStreamAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AppStreamAsyncWaiter.Builder client(AppStreamAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AppStreamAsyncWaiter build() {
            return new DefaultAppStreamAsyncWaiter(this);
        }
    }
}

