/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClientBuilder;
import software.amazon.awssdk.services.appstream.AppStreamServiceClientConfiguration;
import software.amazon.awssdk.services.appstream.DefaultAppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.DefaultAppStreamBaseClientBuilder;
import software.amazon.awssdk.services.appstream.endpoints.AppStreamEndpointProvider;

@SdkInternalApi
final class DefaultAppStreamAsyncClientBuilder
extends DefaultAppStreamBaseClientBuilder<AppStreamAsyncClientBuilder, AppStreamAsyncClient>
implements AppStreamAsyncClientBuilder {
    DefaultAppStreamAsyncClientBuilder() {
    }

    @Override
    public DefaultAppStreamAsyncClientBuilder endpointProvider(AppStreamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppStreamAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppStreamAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AppStreamServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppStreamAsyncClient client = new DefaultAppStreamAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppStreamServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppStreamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

