/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.AppStreamClientBuilder;
import software.amazon.awssdk.services.appstream.AppStreamServiceClientConfiguration;
import software.amazon.awssdk.services.appstream.DefaultAppStreamBaseClientBuilder;
import software.amazon.awssdk.services.appstream.DefaultAppStreamClient;
import software.amazon.awssdk.services.appstream.endpoints.AppStreamEndpointProvider;

@SdkInternalApi
final class DefaultAppStreamClientBuilder
extends DefaultAppStreamBaseClientBuilder<AppStreamClientBuilder, AppStreamClient>
implements AppStreamClientBuilder {
    DefaultAppStreamClientBuilder() {
    }

    @Override
    public DefaultAppStreamClientBuilder endpointProvider(AppStreamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppStreamClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppStreamClientBuilder.validateClientOptions(clientConfiguration);
        AppStreamServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppStreamClient client = new DefaultAppStreamClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppStreamServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppStreamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

