/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.CertificateBasedAuthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateBasedAuthProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateBasedAuthProperties> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CertificateBasedAuthProperties.getter(CertificateBasedAuthProperties::statusAsString)).setter(CertificateBasedAuthProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(CertificateBasedAuthProperties.getter(CertificateBasedAuthProperties::certificateAuthorityArn)).setter(CertificateBasedAuthProperties.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String certificateAuthorityArn;

    private CertificateBasedAuthProperties(BuilderImpl builder) {
        this.status = builder.status;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
    }

    public final CertificateBasedAuthStatus status() {
        return CertificateBasedAuthStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateBasedAuthProperties)) {
            return false;
        }
        CertificateBasedAuthProperties other = (CertificateBasedAuthProperties)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateBasedAuthProperties").add("Status", (Object)this.statusAsString()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateBasedAuthProperties, T> g) {
        return obj -> g.apply((CertificateBasedAuthProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String certificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateBasedAuthProperties model) {
            this.status(model.status);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateBasedAuthStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public CertificateBasedAuthProperties build() {
            return new CertificateBasedAuthProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateBasedAuthProperties> {
        public Builder status(String var1);

        public Builder status(CertificateBasedAuthStatus var1);

        public Builder certificateAuthorityArn(String var1);
    }
}

