/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppBlock;
import software.amazon.awssdk.services.appstream.model.AppBlocksCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppBlocksResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeAppBlocksResponse> {
    private static final SdkField<List<AppBlock>> APP_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppBlocks").getter(DescribeAppBlocksResponse.getter(DescribeAppBlocksResponse::appBlocks)).setter(DescribeAppBlocksResponse.setter(Builder::appBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAppBlocksResponse.getter(DescribeAppBlocksResponse::nextToken)).setter(DescribeAppBlocksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppBlock> appBlocks;
    private final String nextToken;

    private DescribeAppBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.appBlocks = builder.appBlocks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppBlocks() {
        return this.appBlocks != null && !(this.appBlocks instanceof SdkAutoConstructList);
    }

    public final List<AppBlock> appBlocks() {
        return this.appBlocks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppBlocks() ? this.appBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppBlocksResponse)) {
            return false;
        }
        DescribeAppBlocksResponse other = (DescribeAppBlocksResponse)((Object)obj);
        return this.hasAppBlocks() == other.hasAppBlocks() && Objects.equals(this.appBlocks(), other.appBlocks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppBlocksResponse").add("AppBlocks", this.hasAppBlocks() ? this.appBlocks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppBlocks": {
                return Optional.ofNullable(clazz.cast(this.appBlocks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppBlocksResponse, T> g) {
        return obj -> g.apply((DescribeAppBlocksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<AppBlock> appBlocks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppBlocksResponse model) {
            super(model);
            this.appBlocks(model.appBlocks);
            this.nextToken(model.nextToken);
        }

        public final List<AppBlock.Builder> getAppBlocks() {
            List<AppBlock.Builder> result = AppBlocksCopier.copyToBuilder(this.appBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppBlocks(Collection<AppBlock.BuilderImpl> appBlocks) {
            this.appBlocks = AppBlocksCopier.copyFromBuilder(appBlocks);
        }

        @Override
        public final Builder appBlocks(Collection<AppBlock> appBlocks) {
            this.appBlocks = AppBlocksCopier.copy(appBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlocks(AppBlock ... appBlocks) {
            this.appBlocks(Arrays.asList(appBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlocks(Consumer<AppBlock.Builder> ... appBlocks) {
            this.appBlocks(Stream.of(appBlocks).map(c -> (AppBlock)((AppBlock.Builder)AppBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAppBlocksResponse build() {
            return new DescribeAppBlocksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppBlocksResponse> {
        public Builder appBlocks(Collection<AppBlock> var1);

        public Builder appBlocks(AppBlock ... var1);

        public Builder appBlocks(Consumer<AppBlock.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

