/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.UsageReportSubscription;
import software.amazon.awssdk.services.appstream.model.UsageReportSubscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUsageReportSubscriptionsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeUsageReportSubscriptionsResponse> {
    private static final SdkField<List<UsageReportSubscription>> USAGE_REPORT_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsageReportSubscriptions").getter(DescribeUsageReportSubscriptionsResponse.getter(DescribeUsageReportSubscriptionsResponse::usageReportSubscriptions)).setter(DescribeUsageReportSubscriptionsResponse.setter(Builder::usageReportSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageReportSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageReportSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeUsageReportSubscriptionsResponse.getter(DescribeUsageReportSubscriptionsResponse::nextToken)).setter(DescribeUsageReportSubscriptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_REPORT_SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<UsageReportSubscription> usageReportSubscriptions;
    private final String nextToken;

    private DescribeUsageReportSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.usageReportSubscriptions = builder.usageReportSubscriptions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasUsageReportSubscriptions() {
        return this.usageReportSubscriptions != null && !(this.usageReportSubscriptions instanceof SdkAutoConstructList);
    }

    public List<UsageReportSubscription> usageReportSubscriptions() {
        return this.usageReportSubscriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageReportSubscriptions() ? this.usageReportSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsageReportSubscriptionsResponse)) {
            return false;
        }
        DescribeUsageReportSubscriptionsResponse other = (DescribeUsageReportSubscriptionsResponse)((Object)obj);
        return this.hasUsageReportSubscriptions() == other.hasUsageReportSubscriptions() && Objects.equals(this.usageReportSubscriptions(), other.usageReportSubscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUsageReportSubscriptionsResponse").add("UsageReportSubscriptions", this.hasUsageReportSubscriptions() ? this.usageReportSubscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageReportSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.usageReportSubscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsageReportSubscriptionsResponse, T> g) {
        return obj -> g.apply((DescribeUsageReportSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<UsageReportSubscription> usageReportSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsageReportSubscriptionsResponse model) {
            super(model);
            this.usageReportSubscriptions(model.usageReportSubscriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<UsageReportSubscription.Builder> getUsageReportSubscriptions() {
            if (this.usageReportSubscriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usageReportSubscriptions != null ? (Collection)this.usageReportSubscriptions.stream().map(UsageReportSubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usageReportSubscriptions(Collection<UsageReportSubscription> usageReportSubscriptions) {
            this.usageReportSubscriptions = UsageReportSubscriptionListCopier.copy(usageReportSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageReportSubscriptions(UsageReportSubscription ... usageReportSubscriptions) {
            this.usageReportSubscriptions(Arrays.asList(usageReportSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageReportSubscriptions(Consumer<UsageReportSubscription.Builder> ... usageReportSubscriptions) {
            this.usageReportSubscriptions(Stream.of(usageReportSubscriptions).map(c -> (UsageReportSubscription)((UsageReportSubscription.Builder)UsageReportSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsageReportSubscriptions(Collection<UsageReportSubscription.BuilderImpl> usageReportSubscriptions) {
            this.usageReportSubscriptions = UsageReportSubscriptionListCopier.copyFromBuilder(usageReportSubscriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeUsageReportSubscriptionsResponse build() {
            return new DescribeUsageReportSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUsageReportSubscriptionsResponse> {
        public Builder usageReportSubscriptions(Collection<UsageReportSubscription> var1);

        public Builder usageReportSubscriptions(UsageReportSubscription ... var1);

        public Builder usageReportSubscriptions(Consumer<UsageReportSubscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

