/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyImageRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CopyImageRequest> {
    private static final SdkField<String> SOURCE_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyImageRequest.getter(CopyImageRequest::sourceImageName)).setter(CopyImageRequest.setter(Builder::sourceImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageName").build()}).build();
    private static final SdkField<String> DESTINATION_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyImageRequest.getter(CopyImageRequest::destinationImageName)).setter(CopyImageRequest.setter(Builder::destinationImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationImageName").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyImageRequest.getter(CopyImageRequest::destinationRegion)).setter(CopyImageRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()}).build();
    private static final SdkField<String> DESTINATION_IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyImageRequest.getter(CopyImageRequest::destinationImageDescription)).setter(CopyImageRequest.setter(Builder::destinationImageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationImageDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_NAME_FIELD, DESTINATION_IMAGE_NAME_FIELD, DESTINATION_REGION_FIELD, DESTINATION_IMAGE_DESCRIPTION_FIELD));
    private final String sourceImageName;
    private final String destinationImageName;
    private final String destinationRegion;
    private final String destinationImageDescription;

    private CopyImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImageName = builder.sourceImageName;
        this.destinationImageName = builder.destinationImageName;
        this.destinationRegion = builder.destinationRegion;
        this.destinationImageDescription = builder.destinationImageDescription;
    }

    public String sourceImageName() {
        return this.sourceImageName;
    }

    public String destinationImageName() {
        return this.destinationImageName;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public String destinationImageDescription() {
        return this.destinationImageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationImageDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageRequest)) {
            return false;
        }
        CopyImageRequest other = (CopyImageRequest)((Object)obj);
        return Objects.equals(this.sourceImageName(), other.sourceImageName()) && Objects.equals(this.destinationImageName(), other.destinationImageName()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.destinationImageDescription(), other.destinationImageDescription());
    }

    public String toString() {
        return ToString.builder((String)"CopyImageRequest").add("SourceImageName", (Object)this.sourceImageName()).add("DestinationImageName", (Object)this.destinationImageName()).add("DestinationRegion", (Object)this.destinationRegion()).add("DestinationImageDescription", (Object)this.destinationImageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImageName": {
                return Optional.ofNullable(clazz.cast(this.sourceImageName()));
            }
            case "DestinationImageName": {
                return Optional.ofNullable(clazz.cast(this.destinationImageName()));
            }
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "DestinationImageDescription": {
                return Optional.ofNullable(clazz.cast(this.destinationImageDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyImageRequest, T> g) {
        return obj -> g.apply((CopyImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String sourceImageName;
        private String destinationImageName;
        private String destinationRegion;
        private String destinationImageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageRequest model) {
            super(model);
            this.sourceImageName(model.sourceImageName);
            this.destinationImageName(model.destinationImageName);
            this.destinationRegion(model.destinationRegion);
            this.destinationImageDescription(model.destinationImageDescription);
        }

        public final String getSourceImageName() {
            return this.sourceImageName;
        }

        @Override
        public final Builder sourceImageName(String sourceImageName) {
            this.sourceImageName = sourceImageName;
            return this;
        }

        public final void setSourceImageName(String sourceImageName) {
            this.sourceImageName = sourceImageName;
        }

        public final String getDestinationImageName() {
            return this.destinationImageName;
        }

        @Override
        public final Builder destinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
            return this;
        }

        public final void setDestinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final String getDestinationImageDescription() {
            return this.destinationImageDescription;
        }

        @Override
        public final Builder destinationImageDescription(String destinationImageDescription) {
            this.destinationImageDescription = destinationImageDescription;
            return this;
        }

        public final void setDestinationImageDescription(String destinationImageDescription) {
            this.destinationImageDescription = destinationImageDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyImageRequest build() {
            return new CopyImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyImageRequest> {
        public Builder sourceImageName(String var1);

        public Builder destinationImageName(String var1);

        public Builder destinationRegion(String var1);

        public Builder destinationImageDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

