/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.User;
import software.amazon.awssdk.services.appstream.model.UserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUsersResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeUsersResponse> {
    private static final SdkField<List<User>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeUsersResponse.getter(DescribeUsersResponse::users)).setter(DescribeUsersResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUsersResponse.getter(DescribeUsersResponse::nextToken)).setter(DescribeUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<User> users;
    private final String nextToken;

    private DescribeUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.nextToken = builder.nextToken;
    }

    public List<User> users() {
        return this.users;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersResponse)) {
            return false;
        }
        DescribeUsersResponse other = (DescribeUsersResponse)((Object)obj);
        return Objects.equals(this.users(), other.users()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUsersResponse").add("Users", this.users()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsersResponse, T> g) {
        return obj -> g.apply((DescribeUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<User> users = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersResponse model) {
            super(model);
            this.users(model.users);
            this.nextToken(model.nextToken);
        }

        public final Collection<User.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(User::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UserListCopier.copyFromBuilder(users);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeUsersResponse build() {
            return new DescribeUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUsersResponse> {
        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder users(Consumer<User.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

