/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;

public class DescribeImagesPublisher
implements SdkPublisher<DescribeImagesResponse> {
    private final AppStreamAsyncClient client;
    private final DescribeImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImagesPublisher(AppStreamAsyncClient client, DescribeImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImagesPublisher(AppStreamAsyncClient client, DescribeImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeImagesPublisher resume(DescribeImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImagesPublisher(this.client, (DescribeImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImagesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeImagesResponseFetcher
    implements AsyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImagesResponse> nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesPublisher.this.client.describeImages(DescribeImagesPublisher.this.firstRequest);
            }
            return DescribeImagesPublisher.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

