/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;

public class DescribeImagesIterable
implements SdkIterable<DescribeImagesResponse> {
    private final AppStreamClient client;
    private final DescribeImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImagesIterable(AppStreamClient client, DescribeImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public Iterator<DescribeImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeImagesIterable resume(DescribeImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImagesIterable(this.client, (DescribeImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImagesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeImagesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeImagesResponseFetcher
    implements SyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImagesResponse nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesIterable.this.client.describeImages(DescribeImagesIterable.this.firstRequest);
            }
            return DescribeImagesIterable.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

