/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.StorageConnector;

@SdkInternalApi
public class StorageConnectorMarshaller {
    private static final MarshallingInfo<String> CONNECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectorType").build();
    private static final MarshallingInfo<String> RESOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceIdentifier").build();
    private static final StorageConnectorMarshaller instance = new StorageConnectorMarshaller();

    public static StorageConnectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageConnector storageConnector, ProtocolMarshaller protocolMarshaller) {
        if (storageConnector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageConnector.connectorType(), CONNECTORTYPE_BINDING);
            protocolMarshaller.marshall((Object)storageConnector.resourceIdentifier(), RESOURCEIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

