/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.StorageConnectorType;
import software.amazon.awssdk.services.appstream.transform.StorageConnectorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageConnector
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageConnector> {
    private final String connectorType;
    private final String resourceIdentifier;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    public String connectorType() {
        return this.connectorType;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectorType() == null ? 0 : this.connectorType().hashCode());
        hashCode = 31 * hashCode + (this.resourceIdentifier() == null ? 0 : this.resourceIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector)obj;
        if (other.connectorType() == null ^ this.connectorType() == null) {
            return false;
        }
        if (other.connectorType() != null && !other.connectorType().equals(this.connectorType())) {
            return false;
        }
        if (other.resourceIdentifier() == null ^ this.resourceIdentifier() == null) {
            return false;
        }
        return other.resourceIdentifier() == null || other.resourceIdentifier().equals(this.resourceIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectorType() != null) {
            sb.append("ConnectorType: ").append(this.connectorType()).append(",");
        }
        if (this.resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.resourceIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String connectorType;
        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            this.setConnectorType(model.connectorType);
            this.setResourceIdentifier(model.resourceIdentifier);
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final void setConnectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public StorageConnector build() {
            return new StorageConnector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageConnector> {
        public Builder connectorType(String var1);

        public Builder connectorType(StorageConnectorType var1);

        public Builder resourceIdentifier(String var1);
    }
}

